#include <iostream>
#include <vector>
#include <algorithm>
#include <bits/stdc++.h>

using namespace std;

struct suma_vred{
    long vrednost;
    long long suma;

    bool operator<(suma_vred &t){
        return t.suma < suma;
    };

    bool operator==(const suma_vred &t){
        return (t.suma == suma) && (t.vrednost == vrednost);
    };

    bool operator==(const long &vred){
        return (vred == vrednost);
    };
};

vector<suma_vred> lista_suma_vrednosti(const vector<long>& a) {
    map<long, long long> suma;

    for (int x : a) suma[x] += x;

    vector<suma_vred> out;
    out.reserve(suma.size());
    for (auto &kv : suma) out.push_back({kv.first, kv.second});

    sort(out.begin(), out.end());

    return out;
}

int main()
{

    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long n, q, zbir;

    cin >> n >> q;

    vector<long> a;

    vector<suma_vred> sume_vrednosti;
    sume_vrednosti.reserve();

    for(int i=0; i<n; i++){
        long pom;
        cin >> pom;
        a.push_back(pom);

        auto it = find(sume_vrednosti.begin(), sume_vrednosti.end(), pom);

        if (it != sume_vrednosti.end()) {
            // nadjen
            int pos = it - sume_vrednosti.begin();
            sume_vrednosti[pos].suma += pom;
        }
        else {
                // nije nadjen
                suma_vred pom_sv;
                pom_sv.vrednost = pom;
                pom_sv.suma = pom;
                sume_vrednosti.push_back(pom_sv);
        }

    }

    sort(sume_vrednosti.begin(), sume_vrednosti.end());

    //vector<suma_vred> sume_vrednosti = lista_suma_vrednosti(a);
    vector<long> izlaz;

    for(int i=0; i<q; i++){
        long t, x, y;
        zbir = 0;
        cin >> t;
        if(t == 1){
            cin >> x;
            for(int i=(n-x); i < sume_vrednosti.size(); i++){
                zbir += sume_vrednosti[i].suma;
            }
            izlaz.push_back(zbir);
        }
        else{
            cin >> x >> y;

            auto it = find(sume_vrednosti.begin(), sume_vrednosti.end(), a[x-1]);
            if (it != sume_vrednosti.end()) {
                // nadjen
                int pos = it - sume_vrednosti.begin();
                sume_vrednosti[pos].suma -= a[x-1];
            }

            it = find(sume_vrednosti.begin(), sume_vrednosti.end(), y);
            if (it != sume_vrednosti.end()) {
                // nadjen
                int pos = it - sume_vrednosti.begin();
                sume_vrednosti[pos].suma += y;
            }  else {
                // nije nadjen
                suma_vred pom_sv;
                pom_sv.vrednost = y;
                pom_sv.suma = y;
                sume_vrednosti.push_back(pom_sv);
        }

            a[x-1] = y;
            //sume_vrednosti = lista_suma_vrednosti(a);


        }
    }

    for(long s : izlaz){
        cout << s << endl;
    }


    return 0;
}